<?php 
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.4.0
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<li <?php post_class(); ?>>
	<?php
	
	/*
	 * woocommerce_before_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 * woocommerce_before_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_show_product_loop_sale_flash - 10
	 * @hooked woocommerce_template_loop_product_thumbnail - 10
	 */
	$attachment_ids = $product->get_gallery_image_ids();
	if ( $attachment_ids ) {
		?>
		<div class="product-thumbnails">
			<div class="flexslider">
				<ul class="slides">
					<?php
		    		$i=0;
					foreach ( $attachment_ids as $attachment_id ) {
						$i++;
		                $images = wp_get_attachment_image_src( $attachment_id, 'automatic-image-product' );
		                ?>
		                <li>
							<img src="<?php echo esc_url($images[0]); ?>" alt="image-product">
						</li>
		                <?php
					}
					?>
				</ul>
			</div>
		</div>
		<?php
	}else{
		?>
		<div class="product-thumbnails">
			<?php
				the_post_thumbnail( 'automatic-image-product' );
			?>
		</div>
		<?php
	}
    $price = get_post_meta( get_the_ID() , '_regular_price', true);
    $sale = get_post_meta( get_the_ID() , '_sale_price', true);
    if ( $sale != '' && $price!='' ) :
    $discount = number_format( 100 - ($sale*100)/$price ,0,",","");
  	?>
    	<div class="info-alert"><span class="automatic-title">-<?php echo esc_html($discount);?>%</span></div>
	<?php
	elseif ( $product->is_featured() ) :
		echo '<div class="info-alert"><span class="automatic-title">'.esc_html__('Hot','automatic').'</span></div>';
	endif;


	/**
	 * woocommerce_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_template_loop_product_title - 10
	 */

	automatic_product_title($product); 
	
	automatic_product_term($product);
    ?>
	<div class="format-price-addcart">
		<div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
		<div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
	</div> 
		<?php 
		automatic_product_share_yith($product);
		?> 
</li>
